﻿<%
'--------------------------------------------
' 名称：Show_Global_Labels( ByRef Template )
' 作用：替换全局标记
'--------------------------------------------
Sub Show_Global_Labels( ByRef Template )
	Dim I,Widget
	Template = Replace( Template, "{*Path*}", BlogPath )
	Template = Replace( Template, "{*Name*}", BlogName )
	Template = Replace( Template, "{*Description*}", BlogDescription )
	Template = Replace( Template, "{*Domain*}", BlogDomain )
	Template = Replace( Template, "{*KeyWords*}", BlogKeyWords )
	Template = Replace( Template, "{*Version*}", BlogVersion )
	Template = Replace( Template, "{*Style*}", BlogStyle )
End Sub

'--------------------------------------------
' 名称：Show_Widget( ByVal WidgetName, ByVal TemplateName, ByVal ShowType )
' 作用：替换 Widget.html 中的局部标记
'--------------------------------------------
Function Show_Widget( ByVal WidgetName, ByVal Template, ByVal ShowType )
	Dim Widget_Title,Widget_Function,I
	Widget_Title = "" : Widget_Function = ""
	For I = 0 To UBound( WidgetItem, 2 )
		If WidgetItem( 0, I ) = WidgetName Then
			Widget_Title = WidgetItem( 1, I )
			Widget_Function = WidgetItem( 2, I )
			Exit For
		End If
	Next
	If Widget_Title = "" Then
		Show_Widget = ""
	Else
		Template = Replace( Template, "$Widget_ID$", "Widget_" & WidgetName )
		Template = Replace( Template, "$Widget_Title$", Widget_Title )
		Template = Replace( Template, "$Widget_Content$", Widget_Execute( Widget_Function,ShowType ) )
		Show_Widget = Template
	End If
End Function

'--------------------------------------------
' 名称：Widget_Execute( ByVal Widget_Function, ByVal ShowType )
' 作用：
'--------------------------------------------
Function Widget_Execute( ByVal Widget_Function, ByVal ShowType )
	Select Case Widget_Function
	Case "Show_Category"
		Widget_Execute = Show_Category()
	Case "Show_NewArticle"
		Widget_Execute = Show_NewArticle()
	Case "Show_HotArticle"
		Widget_Execute = Show_HotArticle()
	Case "Show_RndArticle"
		Widget_Execute = Show_RndArticle()
	Case "Show_NewComment"
		Widget_Execute = Show_NewComment()
	Case "Show_NewGuestbook"
		Widget_Execute = Show_NewGuestbook()
	Case "Show_Link"
		Widget_Execute = Show_Link()
	Case "Show_Count"
		Widget_Execute = Show_Count()
	Case "Show_Other"
		Widget_Execute = Show_Other( ShowType )
	Case Else
		Widget_Execute = Widget_Function
	End Select
End Function

'--------------------------------------------
' 名称：Show_Category()
' 作用：
'--------------------------------------------
Function Show_Category()
	Dim Temp,i
	Temp = ""
	If IsEmpty( SideArticleClass ) Then
		Temp = Temp + "<li>-</li>"
	Else
		For i = 0 To UBound( SideArticleClass, 2 )
			Temp = Temp + "<li><a href=""" & BlogPath & "Default.asp?class=" & SideArticleClass( 0, i ) & """ title=""" & SideArticleClass( 2, i ) & """>" & SideArticleClass( 0, i ) & "(" & SideArticleClass( 1, i ) & ")</a> [<a href=""" & BlogPath & "Feed.asp?cate=" & vbsEscape( SideArticleClass( 0, i ) ) & """ title=""订阅 " & SideArticleClass( 0, i ) & " 分类"">RSS</a>]</li>"
		Next
	End If
	Show_Category = Temp
End Function

'--------------------------------------------
' 名称：Show_NewArticle()
' 作用：
'--------------------------------------------
Function Show_NewArticle()
	Dim Temp,i
	Temp = ""
	If IsEmpty( SideNewArticle ) Then
		Temp = Temp + "<li>-</li>"
	Else
		For i = 0 To UBound( SideNewArticle, 2 )
			If SideNewArticle( 2, i ) = "动态" Then
				Temp = Temp + "<li><a href=""" & BlogPath & "Read.asp?id=" & SideNewArticle( 0, i ) & """>" & SideNewArticle( 1, i ) & "</a></li>"
			Else
				Temp = Temp + "<li><a href=""" & BlogPath & "Article/" & SideNewArticle( 4, i ) & "/" & SideNewArticle( 3, i ) & """>" & SideNewArticle( 1, i ) & "</a></li>"
			End If
		Next
	End If
	Show_NewArticle = Temp
End Function

'--------------------------------------------
' 名称：Show_HotArticle()
' 作用：
'--------------------------------------------
Function Show_HotArticle()
	Dim Temp,i
	Temp = ""
	If IsEmpty( SideHotArticle ) Then
		Temp = Temp + "<li>-</li>"
	Else
		For i = 0 To UBound( SideHotArticle, 2 )
			If SideHotArticle( 2, i ) = "动态" Then
				Temp = Temp + "<li><a href=""" & BlogPath & "Read.asp?id=" & SideHotArticle( 0, i ) & """>" & SideHotArticle( 1, i ) & "</a></li>"
			Else
				Temp = Temp + "<li><a href=""" & BlogPath & "Article/" & SideHotArticle( 4, i ) & "/" & SideHotArticle( 3, i ) & """>" & SideHotArticle( 1, i ) & "</a></li>"
			End If
		Next
	End If
	Show_HotArticle = Temp
End Function

'--------------------------------------------
' 名称：Show_RndArticle()
' 作用：
'--------------------------------------------
Function Show_RndArticle()
	Dim Temp,i
	Temp = ""
	If IsEmpty( SideRndArticle ) Then
		Temp = Temp + "<li>-</li>"
	Else
		For i = 0 To UBound( SideRndArticle, 2 )
			If SideRndArticle( 2, i ) = "动态" Then
				Temp = Temp + "<li><a href=""" & BlogPath & "Read.asp?id=" & SideRndArticle( 0, i ) & """>" & SideRndArticle( 1, i ) & "</a></li>"
			Else
				Temp = Temp + "<li><a href=""" & BlogPath & "Article/" & SideRndArticle( 4, i ) & "/" & SideRndArticle( 3, i ) & """>" & SideRndArticle( 1, i ) & "</a></li>"
			End If
		Next
	End If
	Show_RndArticle = Temp
End Function

'--------------------------------------------
' 名称：Show_NewComment()
' 作用：
'--------------------------------------------
Function Show_NewComment()
	Dim Temp,i
	Temp = ""
	If IsEmpty( SideNewComment ) Then
		Temp = Temp + "<li>-</li>"
	Else
		For i = 0 To UBound( SideNewComment, 2 )
			If SideNewComment( 3, i ) = "动态" Then
				Temp = Temp + "<li><a href=""" & BlogPath & "Read.asp?id=" & SideNewComment( 2, i ) & """ title=""[" & SideNewComment( 7, i ) & "] - [" & SideNewComment( 6, i ) & "]"">" & DelStr( SideNewComment( 0, i ) ) & "</a></li>"
			Else
				Temp = Temp + "<li><a href=""" & BlogPath & "Article/" & SideNewComment( 5, i ) & "/" & SideNewComment( 4, i ) & """ title=""[" & SideNewComment( 7, i ) & "] - [" & SideNewComment( 6, i ) & "]"">" & DelStr( SideNewComment( 0, i ) ) & "</a></li>"
			End If
		Next
	End If
	Show_NewComment = Temp
End Function

'--------------------------------------------
' 名称：Show_NewGuestbook()
' 作用：
'--------------------------------------------
Function Show_NewGuestbook()
	Dim Temp,i
	Temp = ""
	If IsEmpty( SideNewGuestbook ) Then
		Temp = Temp + "<li>-</li>"
	Else
		For i = 0 To UBound( SideNewGuestbook, 2 )
			Temp = Temp + "<li><a href=""" & BlogPath & "Guestbook.asp"" title=""[" & SideNewGuestbook( 2, i ) & "] " & DelStr( SideNewGuestbook( 1, i ) ) & """>" & DelStr( SideNewGuestbook( 1, i ) ) & "</a></li>"
		Next
	End If
	Show_NewGuestbook = Temp
End Function

'--------------------------------------------
' 名称：Show_Link()
' 作用：
'--------------------------------------------
Function Show_Link()
	Dim Temp,i
	Temp = ""
	If IsEmpty( SideLink ) Then
		Temp = Temp + "<li>-</li>"
	Else
		For i = 0 To UBound( SideLink, 2 )
			Temp = Temp + "<li><a href=""" & SideLink( 2, i ) & """ title=""" & SideLink( 1, i ) & """ target=""_blank"">" & SideLink( 0, i ) & "</a></li>"
		Next
	End If
	Show_Link = Temp
End Function

'--------------------------------------------
' 名称：Show_Count()
' 作用：
'--------------------------------------------
Function Show_Count()
	Dim Temp
	Temp = "<li>建站：" & SideBuildDate & "</li>"
	Temp = Temp + "<li>日志：" & SideArticleNum & "篇</li>"
	Temp = Temp + "<li>评论：" & SideCommentNum & "篇</li>"
	Temp = Temp + "<li>留言：" & SideGuestbookNum & "篇</li>"
	Temp = Temp + "<li>用户：" & SideUserNum & "人</li>"
	Temp = Temp + "<li>访问：" & SideVisitNum & "次</li>"
	Temp = Temp + "<li>在线：" & OnlineNum & "人</li>"
	Show_Count = Temp
End Function

'--------------------------------------------
' 名称：Show_Other( ByVal ShowType )
' 作用：
'--------------------------------------------
Function Show_Other( ByVal ShowType )
	Dim Temp
	If CheckLogin() And ShowType <> 1 Then
		Temp = "<li><a href=""" & BlogPath & "Login.asp?action=Logout"">退出</a></li>"
		Temp = Temp + "<li><a href=""" & BlogPath & "User.asp"">用户中心</a></li>"
		If CheckAdmin() Then
			Temp = Temp + "<li><a href=""" & BlogPath & "Admin/Admin_Login.asp"">后台管理</a></li>"
		End If
	Else
		Temp = "<li><a href=""" & BlogPath & "Login.asp"">登录</a></li>"
		Temp = Temp + "<li><a href=""" & BlogPath & "Login.asp?action=Register"">注册</a></li>"
	End If
	Temp = Temp + "<li>RSS： <a href=""" & BlogPath & "Feed.asp"">所有日志</a></li>"
	Temp = Temp + "<li>编码：UTF-8</li>"
	Show_Other = Temp
End Function

'--------------------------------------------
' 名称：Function ShowHead( ByVal PageName, ByVal ScriptLink, ByVal TemplateName )
' 作用：替换 Head.html 中的局部标记
' 说明：为了减小开销，调用此函数后系统缓存变量 TemplateHead 的值将被改变，无法再次进行标记替换
'--------------------------------------------
Function ShowHead( ByVal PageName, ByVal ScriptLink, ByVal TemplateName )
	Dim TemplateHead
	TemplateHead = Temp_Load( TemplateName )
	Show_Global_Labels TemplateHead
	TemplateHead = Replace( TemplateHead, "$PageName$", PageName )
	TemplateHead = Replace( TemplateHead, "$ScriptLink$", ScriptLink & "<script type = ""text/javascript"" src = """ & BlogPath & "Include/Common.js""></script>" )
	ShowHead = TemplateHead
End Function

'--------------------------------------------
' 名称：ShowSide( ByVal TemplateName, ByVal ShowType )
' 作用：替换 Side.html 中的局部标记
' 说明：为了减小开销，调用此函数后系统缓存变量 TemplateSide 的值将被改变，无法再次进行标记替换
'--------------------------------------------
Function ShowSide( ByVal TemplateName, ByVal ShowType )
	Dim TemplateSide,TemplateWidget,I
	TemplateSide = Temp_Load( TemplateName )
	TemplateWidget = Temp_Load( "Widget.html" )
	Show_Global_Labels TemplateWidget
	For I = 0 To UBound( WidgetItem, 2 )
		If InStr(TemplateSide,"$Widget-" & WidgetItem( 0, I ) & "$") > 0 Then
			TemplateSide = Replace( TemplateSide, "$Widget-" & WidgetItem( 0, I ) & "$", Show_Widget( WidgetItem( 0, I ), TemplateWidget, ShowType ) )
		End If
	Next
	Show_Global_Labels TemplateSide
	ShowSide = TemplateSide
End Function

'--------------------------------------------
' 名称：ShowFoot( ByVal TemplateName )
' 作用：替换 Foot.html 中的局部标记
' 说明：为了减小开销，调用此函数后系统缓存变量 TemplateFoot 的值将被改变，无法再次进行标记替换
'--------------------------------------------
Function ShowFoot( ByVal TemplateName )
	Dim Temp,TemplateFoot
	TemplateFoot = Temp_Load( TemplateName )
	Show_Global_Labels TemplateFoot
	TemplateFoot = Replace(TemplateFoot, "$Designer$", BlogDesigner)
	TemplateFoot = Replace(TemplateFoot, "$BeiAn$", BlogBeiAn)
	Temp = "Processed In " & FormatNumber(Timer() - StartTime, 4, -1) & " Second(s) , " & QueryNum & " Queries"
	TemplateFoot = Replace(TemplateFoot, "$Info$", Temp)

	ShowFoot = TemplateFoot
End Function

'--------------------------------------------
' 名称：ShowMessage( MessageText, URL )
' 作用：显示提示信息
' 说明：为了减小开销，调用此函数后系统缓存变量 TemplateMessage 的值将被改变，无法再次进行标记替换
'--------------------------------------------
Sub ShowMessage( MessageText, URL )
	'之前的输出全部撤销
	Response.Clear

	Dim PageName,TemplateMessage
	PageName = "提示信息"

	TemplateMessage = Temp_Load("Message.html")
	Show_Global_Labels TemplateMessage

	TemplateMessage = Replace( TemplateMessage, "$MenuItem$", ShowMenu( PageName ) )
	TemplateMessage = Replace( TemplateMessage, "$Message_Text$", MessageText )
	If URL <> "" Then
		TemplateMessage = Replace( TemplateMessage, "$Head$", ShowHead(PageName, "<meta http-equiv = ""refresh"" content = ""3;url = " & URL & """>", "Head.html") )
		TemplateMessage = Replace( TemplateMessage, "$Refresh_Text$", "<a href=""" & URL & """>如果您的浏览器没有自动跳转,请点击这里</a>" )
	Else
		TemplateMessage = Replace( TemplateMessage, "$Head$", ShowHead(PageName, "", "Head.html") )
		TemplateMessage = Replace( TemplateMessage, "$Refresh_Text$", "" )
	End If
	TemplateMessage = Replace( TemplateMessage, "$Foot$", ShowFoot( "Foot.html" ) )

	Response.Write( TemplateMessage )
End Sub

'--------------------------------------------
' 名称：ShowMenu( PageName )
' 作用：显示导航菜单
'--------------------------------------------
Function ShowMenu( PageName )
	Dim i,m
	For i = 0 To UBound( MenuItem, 2 )
		If MenuItem(1, i) = PageName Then
			If MenuItem(2, i) = 0 Then
				m = m + "<li class=""CurrentPageItem""><a href=""" & BlogPath & MenuItem(3, i) & """ title=""" & MenuItem(1, i) & """>" & MenuItem(1, i) & "</a></li>"
			Else
				m = m + "<li class=""CurrentPageItem""><a href=""" & MenuItem(3, i) & """ title=""" & MenuItem(1, i) & """ target=""_blank"">" & MenuItem(1, i) & "</a></li>"
			End If
		Else
			If MenuItem(2, i) = 0 Then
				m = m + "<li><a href=""" & BlogPath & MenuItem(3, i) & """ title=""" & MenuItem(1, i) & """>" & MenuItem(1, i) & "</a></li>"
			Else
				m = m + "<li><a href=""" & MenuItem(3, i) & """ title=""" & MenuItem(1, i) & """ target=""_blank"">" & MenuItem(1, i) & "</a></li>"
			End If
		End If
	Next
	If CheckAdmin() Then
		If PageName = "前台管理" Then
			m = m + "<li class=""CurrentPageItem""><a href=""" & BlogPath & "Admin.asp"" title=""管理"">管理</a></li>"
		Else
			m = m + "<li><a href=""" & BlogPath & "Admin.asp"" title=""管理"">管理</a></li>"
		End If
	End If

	ShowMenu = m
End Function

'--------------------------------------------
' 名称：ShowAnnouncement()
' 作用：显示公告
'--------------------------------------------
Function ShowAnnouncement()
	Dim Announcement
	'Announcement = "<div id = ""Main_Announcement""></div><script type = ""text/javascript"" src= ""GongGao.js""></script>"

	ShowAnnouncement = ""
End Function

'--------------------------------------------
' 名称：ShowDefault(ShowType, CurrentPage, ClassName)
' 作用：返回首页文章列表
'--------------------------------------------
Function ShowDefault(ShowType, CurrentPage, ClassName)
	Dim Article, Temp, ArticleDate, ArticleTime, ArticleArr, Address, PageCount, Content, AdminInfo, SQL, Rs, ArticleNum, TagsArr, Tags, TagsI,TemplateArticle,I

	Set Rs = Server.CreateObject("Adodb.RecordSet")
	If ClassName <> "" Then
		SQL = "select * from " & PrefixStr & "Article where IsDel=False and Class='" & ClassName & "' order by IsTop asc,ID desc"
	Else
		SQL = "select * from " & PrefixStr & "Article where IsDel=False order by IsTop asc, ID desc"
	End If
	Rs.Open SQL,conn, 1, 1
	If Rs.EOF And Rs.BOF Then
		ShowDefault = "<br /><center><strong>没有找到日志！</strong></center>"
		Rs.Close
		Set Rs = Nothing
		QueryNum = QueryNum + 1
		Exit Function
	End If
	If ( CurrentPage - 1 ) * BlogMaxPerPage + 1 > Rs.RecordCount Then
		ShowDefault = "<br /><center><strong>此范围内没有日志。</strong></center>"
		Rs.Close
		Set Rs = Nothing
		QueryNum = QueryNum + 1
		Exit Function
	End If
	Rs.AbsolutePosition = ( CurrentPage - 1 ) * BlogMaxPerPage + 1
	ArticleArr = Rs.GetRows( BlogMaxPerPage )
	ArticleNum = Rs.RecordCount
	Rs.Close
	Set Rs = Nothing
	QueryNum = QueryNum + 1

	TemplateArticle = Temp_Load("Article.html")
	For I = 0 To UBound( WidgetItem, 2 )
		TemplateArticle = Replace( TemplateArticle, "$Widget-" & WidgetItem( 0, I ) & "$", "" )
	Next
	Article = ""
	If ShowType = 1 Then
		'------------- 标准模式 --------------
		For PageCount = 0 To UBound( ArticleArr, 2 )
			Temp = TemplateArticle
			ArticleDate = ArticleArr(2, PageCount)
			'ArticleDate = "<h2>" & Right(ArticleTime,(Len(ArticleTime) - InStrRev(ArticleTime,"-"))) & "</h2><h5>" & Left(ArticleTime,InStrRev(ArticleTime,"-")-1) & "</h5>"
			Content = ArticleArr(9, PageCount)
			'判断是否有[showall]字符串并作相应处理
			If InStr(Content,"[showall]") <> 0 Then
				Content = Left(Content,InStr(Content,"[showall]")-1)
			End If
			If CheckAdmin = True Then
				If ArticleArr(7, PageCount) Then
					AdminInfo = "管理：<a href = ""Admin.asp?action=5&id=" & ArticleArr(0, PageCount) & """>[取消置顶]</a>"
				Else
					AdminInfo = "管理：<a href = ""Admin.asp?action=4&id=" & ArticleArr(0, PageCount) & """>[置顶]</a>"
				End If
				If ArticleArr(12, PageCount) = "静态" Then
					If ArticleArr(15, PageCount) = True Then
						AdminInfo = AdminInfo + " <a href = '" & BlogPath & "Admin.asp?action=11&id=" & ArticleArr(0, PageCount) & "'><font color=red>[刷新]</font></a>"
					Else
						AdminInfo = AdminInfo + " <a href = '" & BlogPath & "Admin.asp?action=11&id=" & ArticleArr(0, PageCount) & "'>[刷新]</a>"
					End If
				End If
				AdminInfo = AdminInfo + " <a href = ""Admin.asp?action=2&id=" & ArticleArr(0, PageCount) & """>[修改]</a> <a href='javascript:if(confirm(""确实要删除吗?""))location=" & Chr(34) & "Admin.asp?action=3&id=" & ArticleArr(0, PageCount) & Chr(34) & "'>[删除]</a>"
			End If
			Temp = Replace( Temp, "$ID$", ArticleArr(0, PageCount) )
			If ArticleArr(12, PageCount) = "动态" Then
				Address = BlogPath & "Read.asp?id=" & ArticleArr(0, PageCount)
			Else
				Address = BlogPath & "Article/" & ArticleArr(5, PageCount) & "/" & ArticleArr(13, PageCount)
			End If
			TagsArr = Split( ArticleArr(6, PageCount), "," )
			Tags = "<span class=""Tags"">本文标签："
			For Each TagsI In TagsArr
				Tags = Tags + "<a href=""" & BlogPath & "Search.asp?type=Tag&word=" & TagsI & """>" & TagsI & "</a> "
			Next
			Tags = Tags + "</span>"
			Temp = Replace( Temp, "$Address$", Address )
			Temp = Replace( Temp, "$Date$", ArticleDate )
			If ArticleArr(7, PageCount) = True Then
				Temp = Replace( Temp, "$Title$", "[置顶]" & ArticleArr(1, PageCount) )
			Else
				Temp = Replace( Temp, "$Title$", ArticleArr(1, PageCount) )
			End If
			Temp = Replace( Temp, "$Author$", ArticleArr(4, PageCount) )
			Temp = Replace( Temp, "$Class$", "<a href=""Default.asp?class=" & ArticleArr(5, PageCount) & """>" & ArticleArr(5, PageCount) & "</a>" )
			Temp = Replace( Temp, "$Time$", ArticleArr(3, PageCount) )
			Temp = Replace( Temp, "$Content$", Content )
			Temp = Replace( Temp, "$More$", "<div class = ""Main_Article_More""><a href = """ & Address & """ title=""点击阅读全文"">浏览更多 &#187;</a></div>" )
			Temp = Replace( Temp, "$Tag$", Tags )
			Temp = Replace( Temp, "$Similar$", "" )
			Temp = Replace( Temp, "$Control$", AdminInfo )
			Temp = Replace( Temp, "$Read$", ArticleArr(10, PageCount) )
			Temp = Replace( Temp, "$Comment$", ArticleArr(11, PageCount) )
			Article = Article + Temp
		Next
		'Article = ShowLeader(CurrentPage, ArticleNum, ClassName, "Default.asp") + Article
		Article = Article + ShowLeader(CurrentPage, ArticleNum, ClassName, "Default.asp")
	Else
		'------------- 列表模式 --------------
		For PageCount = 0 To UBound( ArticleArr, 2 )
			Article = Article + "<div class = ""Main_Article"">[" & ArticleArr(2, PageCount) & "]<a href = ""Read.asp?id=" & ArticleArr(0, PageCount) & """>" & ArticleArr(1, PageCount) & "</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" & ArticleArr(10, PageCount) & "|" & ArticleArr(11, PageCount) & "</div>"
		Next
		'Article = ShowLeader(CurrentPage, ArticleNum, ClassName, "Default.asp") + Article
		Article = Article + ShowLeader(CurrentPage, ArticleNum, ClassName, "Default.asp")
	End If
	ShowDefault = Article
End Function

'--------------------------------------------
' 名称：ShowGuestbook(CurrentPage)
' 作用：返回留言列表
'--------------------------------------------
Function ShowGuestbook(CurrentPage)
	Dim Guestbook,Temp,GuestbookArr, PageCount, Content, AdminInfo, SQL, Rs, Gravatar, TemplateComment

	Set Rs = Server.CreateObject("Adodb.RecordSet")
	SQL = "select * from " & PrefixStr & "Guestbook where IsDel=False order by GID desc"
	Rs.Open SQL,conn,1,1
	If Rs.EOF And Rs.BOF Then
		ShowGuestbook = "<div class = ""Main_Article""><div style = ""text-align: center;margin:10px;""><strong>没有找到留言！</strong></div></div>"
		Rs.Close
		Set Rs = Nothing
		QueryNum = QueryNum + 1
		Exit Function
	End If
	If ( CurrentPage - 1 ) * BlogMaxPerPage + 1 > Rs.RecordCount Then
		ShowGuestbook = "<div class = ""Main_Article""><div style = ""text-align: center;margin:10px;""><strong>此范围内没有留言。</strong></div></div>"
		Rs.Close
		Set Rs = Nothing
		QueryNum = QueryNum + 1
		Exit Function
	End If
	Rs.AbsolutePosition = ( CurrentPage - 1 ) * BlogMaxPerPage + 1
	GuestbookArr = Rs.GetRows( BlogMaxPerPage )
	Rs.Close
	Set Rs = Nothing
	QueryNum = QueryNum + 1

	Guestbook = ""
	TemplateComment = Temp_Load("Comment.html")
	For PageCount = 0 To UBound( GuestbookArr, 2 )
		Temp = TemplateComment
		Show_Global_Labels Temp

		If GuestbookArr(5, PageCount) <> "" Then
			Temp = Replace( Temp, "$Auther$", "<a href=""" & GuestbookArr(5, PageCount) & """ rel=""external nofollow"">" & GuestbookArr(1, PageCount) & "</a>" )
		Else
			Temp = Replace( Temp, "$Auther$", GuestbookArr(1, PageCount) )
		End If
		Temp = Replace( Temp, "$Time$", GuestbookArr(6, PageCount) & " " & GuestbookArr(7, PageCount) )
		If GuestbookArr(13, PageCount) = True Then
			Temp = Replace( Temp, "$Content$", GuestbookArr(8, PageCount) )
		Else
			Temp = Replace( Temp, "$Content$", "[此留言需要管理员审核才能显示]" )
		End If
		If GuestbookArr(9, PageCount) <> "" Then
			Temp = Replace( Temp, "$Reply$", "<div class = ""Main_Comment_Reply""><b>" & GuestbookArr(9, PageCount) & "</b><span class=""commentinfo"">[" & GuestbookArr(11, PageCount) & " " & GuestbookArr(12, PageCount) & "]</span><br />" &GuestbookArr(10, PageCount) & "</div>" )
		Else
			Temp = Replace( Temp, "$Reply$", "" )
		End If
		If CheckAdmin = True Then
			Temp = Replace( Temp, "$Control$", "<div class = ""Main_Comment_AdminEditor"" id = """ & GuestbookArr(0, PageCount) & """ style = ""display:none""><form action=""" & BlogPath & "Admin.asp?action=6&id=" & GuestbookArr(0, PageCount) & """ method = ""post"" name = ""GuestbookReply"" id = ""GuestbookReply""><textarea name = ""GuestbookReply"" rows=""4"" cols=""50""></textarea><br /><input type = ""submit"" name = ""Submit"" class=""Main_Button"" value=""回复"" /></form></div><div class = ""Main_AdminInfo"">管理：<a href = ""javascript:ShowHideDiv(" & GuestbookArr(0, PageCount) & ")"">[回复]</a> <a href=""javascript:if(confirm('确实要删除吗?'))location='" & BlogPath & "Admin.asp?action=7&id=" & GuestbookArr(0, PageCount) & "'"">[删除]</a></div>" )
		Else
			Temp = Replace( Temp, "$Control$", "" )
		End If
		If GuestbookArr(3, PageCount) <> "" Then
			Gravatar = Split( GuestbookArr(3, PageCount), "|" )
			Temp = Replace( Temp, "$Gravatar$", "<img src=""http://www.gravatar.com/avatar.php?gravatar_id=" & Gravatar(1) & "?s=32&amp;d=wavatar&amp;r=G"" height=""32"" width=""32"" alt=""Gravatar"" class=""Gravatar"" />" )
		Else
			Temp = Replace( Temp, "$Gravatar$", "<img src=""" & BlogPath & "Style/" & BlogStyle & "/Images/Gravatar.jpg"" height=""32"" width=""32"" alt=""Gravatar"" class=""Gravatar"" />" )
		End If
		Guestbook = Guestbook + Temp
	Next
	Guestbook = Guestbook + "<div id=""HiddenComment""></div>"
	'Guestbook = ShowLeader(CurrentPage, SideGuestbookNum, "", "Guestbook.asp") + Guestbook
	Guestbook = Guestbook + ShowLeader(CurrentPage, SideGuestbookNum, "", "Guestbook.asp")

	ShowGuestbook = Guestbook
End Function

'--------------------------------------------
' 名称：ShowLeader(CurrentPage, ArticleNum, ClassName, PageName)
' 作用：显示导航
'--------------------------------------------
Function ShowLeader(CurrentPage, ArticleNum, ClassName, PageName)
	Dim Leader, PageNum, i

	If (ArticleNum Mod BlogMaxPerPage) = 0 Then 
		PageNum = ArticleNum \ BlogMaxPerPage
	Else 
		PageNum = ArticleNum \ BlogMaxPerPage + 1
	End If 

	If ClassName <> "" Then
		ClassName = "class=" + ClassName + "&"
	Else
		ClassName = ""
	End If

	Leader = "<div class = ""Main_Leader"">分页：" & CurrentPage & "/" & PageNum
	Leader = Leader + "<a href = """ & PageName & "?" & ClassName & "page=1""><img src = """ & BlogPath & "Style/" & BlogStyle & "/images/doubleleft.gif"" alt = ""首页"" title = ""首页"" border = ""0"" /></a>"
	If CurrentPage = 1 Then
		i = 1
	Else
		i = CurrentPage - 1
	End If
	Leader = Leader + "<a href = """ & PageName & "?" & ClassName & "page=" & i & """><img src = """ & BlogPath & "Style/" & BlogStyle & "/images/singleleft.gif"" alt = ""上一页"" title = ""上一页"" border = ""0"" /></a>"

	If CurrentPage > 5 Then
		Leader = Leader + "<span class = ""Main_Leader_Num""> …… "
		For i = CurrentPage-4 To CurrentPage-1
			Leader = Leader + "<a href=""" & PageName & "?" & ClassName & "page=" & i & """>" & i & "</a>"
		Next
	Else
		Leader = Leader + "<span class = ""Main_Leader_Num"">"
		For i = 1 To CurrentPage-1
			Leader = Leader + "<a href=""" & PageName & "?" & ClassName & "page=" & i & """>" & i & "</a>"
		Next
	End If

	Leader = Leader + "<span class=""Main_Leader_Current"">" & CurrentPage & "</span>"

	If PageNum - CurrentPage > 4 Then
		For i = CurrentPage + 1 To CurrentPage + 4
			Leader = Leader + "<a href=""" & PageName & "?" & ClassName & "page=" & i & """>" & i & "</a>"
		Next
		Leader = Leader + " …… </span>"
	Else
		For i = CurrentPage+1 To PageNum
			Leader = Leader + "<a href=""" & PageName & "?" & ClassName & "page=" & i & """>" & i & "</a>"
		Next
		Leader = Leader + "</span>"
	End If

	If CurrentPage >= PageNum Then
		i = PageNum
	Else
		i = CurrentPage + 1
	End If
	Leader = Leader + "<a href = """ & PageName & "?" & ClassName & "page=" & i & """><img src = """ & BlogPath & "Style/" & BlogStyle & "/images/singleright.gif"" alt = ""下一页"" title = ""下一页"" border = ""0"" /></a>"
	Leader = Leader + "<a href = """ & PageName & "?" & ClassName & "page=" & PageNum & """><img src = """ & BlogPath & "Style/" & BlogStyle & "/images/doubleright.gif"" alt = ""尾页"" title = ""尾页"" border = ""0"" /></a></div>"

	ShowLeader = Leader
End Function

'Sub ShowDefault(PageNum, ClassName, TagName)
 ' ShowAnnouncement()
  'If IsNull("Class") And IsNull("Tag") Then
'    ShowLeader(PageNum,App("SideArticleNum"),"Default.asp?")
 '   If PageNum < 4 Then
  '    读取缓存
'    Else
 '     ShowArticleList(PageNum)
  '  End If
'    ShowLeader(****)
 ' ElseIf IsNull("Tag") And Not IsNull("Class") Then
  '  If IsNull(App**) Then
'      ShowMessage("分类"&Class&"不存在。","Default.asp")
 '   Else
  '    ShowLeader(PageNum,App("SideClass"&Class&"Num"),"Default.asp?class="&Class&"&")
'      If PageNum = 1 Then
 '       读取缓存
  '    Else
'        ShowArticleClass(PageNum,Class)
 '     End If
  '    ShowLeader(****)
'    End If
 ' Else
  '  //这个不同于上面两个，仅返回一页内容，根据标签匹配最相似的文章。这个是非常占用资源的，应当谨慎编写，实在不行就砍掉。
'    ShowArticleTag(Tag)
 ' End If
'End Sub

'Show()

'--------------------------------------------
' 名称：ShowArticleDetail(ArticleID,ShowType)
' 作用：返回详细页文章
'--------------------------------------------
Function ShowArticleDetail(ArticleID,ShowType)
	Dim Article,ArticleDate,ArticleTime,Address,Content,Similar,AdminInfo,SQL,TagsArr,TagsI,Tags,TemplateWidget,I
	Set Rs = Server.CreateObject ("adodb.recordset")
	SQL = "select * from " & PrefixStr & "Article where ID=" & ArticleID & " And IsDel=False"
	Rs.Open SQL, Conn, 1, 1
	If Rs.EOF And Rs.BOF Then
		ShowMessage "抱歉，没有找到相应的日志", BlogPath & "Default.asp"
		Response.End
	End If
	Article = Temp_Load("Article.html")
	TemplateWidget = Temp_Load( "Widget.html" )
	For I = 0 To UBound( WidgetItem, 2 )
		If InStr(Article,"$Widget-" & WidgetItem( 0, I ) & "$") > 0 Then
			Article = Replace( Article, "$Widget-" & WidgetItem( 0, I ) & "$", Show_Widget( WidgetItem( 0, I ), TemplateWidget, ShowType ) )
		End If
	Next
	ArticleDate = rs("Date")
	'ArticleDate = "<h2>" & Right(ArticleTime,(Len(ArticleTime) - InStrRev(ArticleTime,"-"))) & "</h2><h5>" & Left(ArticleTime,InStrRev(ArticleTime,"-")-1) & "</h5>"
	Content = Replace(rs("Content"),"[showall]","")
	If ShowType = 0 Then
		If CheckAdmin = True Then
			AdminInfo = "管理：<a href = '" & BlogPath & "Admin.asp?action=2&id=" & rs("ID") & "'>[修改]</a>"
			If Rs("Type") = "静态" Then
				AdminInfo = AdminInfo + " <a href = '" & BlogPath & "Admin.asp?action=11&id=" & Rs("ID") & "'>[刷新]</a>"
			End If
			AdminInfo = AdminInfo + " <a href='javascript:if(confirm(" & Chr(34) & "确实要删除吗?" & Chr(34) & "))location=" & Chr(34) & BlogPath & "Admin.asp?action=3&id=" & rs("ID") & Chr(34) & "'>[删除]</a>"
		End If
	End If
	Article = Replace( Article, "$ID$", rs("ID") )
	If Rs("Type") = "动态" Then
		Address = BlogPath & "Read.asp?id=" & Rs("ID")
	Else
		Address = BlogPath & "Article/" & Rs("Class") & "/" & Rs("Address")
	End If
	TagsArr = Split( Rs("Tag"), "," )
	Tags = "<span class=""Tags"">本文标签："
	For Each TagsI In TagsArr
		Tags = Tags + "<a href=""" & BlogPath & "Search.asp?type=Tag&word=" & TagsI & """>" & TagsI & "</a> "
	Next
	Tags = Tags + "</span>"
	Article = Replace( Article, "$Address$", Address )
	Article = Replace( Article, "$Date$", ArticleDate )
	If Rs("IsTop") Then
		Article = Replace( Article, "$Title$", "[置顶]" & Rs("Title") )
	Else
		Article = Replace( Article, "$Title$", Rs("Title") )
	End If
	Article = Replace( Article, "$Author$", Rs("Author") )
	Article = Replace( Article, "$Class$", "<a href=""" & BlogPath & "Default.asp?class=" & rs("Class") & """>" & rs("Class") & "</a>" )
	Article = Replace( Article, "$Time$", rs("Time") )
	Article = Replace( Article, "$Content$", Content )
	Article = Replace( Article, "$More$", "" )
	Article = Replace( Article, "$Tag$", Tags )
	Similar = "<div id=""Similar"">相关日志：<div id=""Related"">正在加载……</div><script src=""" & BlogPath & "Include/getRelated.asp?id=" & Rs("ID") & "&tag=" & Rs("Tag") & """ type=""text/javascript"" language=""javascript""></script></div>"
	Article = Replace( Article, "$Similar$", Similar )
	Article = Replace( Article, "$Control$", AdminInfo )
	Article = Replace( Article, "$Read$", rs("Read") )
	Article = Replace( Article, "$Comment$", rs("Comment") )
	Rs.Close
	Set Rs = Nothing
	QueryNum = QueryNum + 1
	Show_Global_Labels Article

	ShowArticleDetail = Article
End Function

'--------------------------------------------
' 名称：ShowComment(ArticleID)
' 作用：分页显示评论
'--------------------------------------------
Function ShowComment(ArticleID)
	Dim Comment,Temp,CommentArr, PageCount, Content, AdminInfo, SQL, Rs, Gravatar, TemplateComment

	Set Rs = Server.CreateObject("Adodb.RecordSet")
	SQL = "select * from " & PrefixStr & "Comment where ArticleID=" & ArticleID & " and IsDel=False order by CID desc"
	Rs.Open SQL,conn,1,1
	If Rs.EOF And Rs.BOF Then
		ShowComment = "<div class = ""Main_Comment""><div id=""HiddenComment""></div></div>"
		Rs.Close
		Set Rs = Nothing
		QueryNum = QueryNum + 1
		Exit Function
	End If
	CommentArr = Rs.GetRows( Rs.RecordCount )
	Rs.Close
	Set Rs = Nothing
	QueryNum = QueryNum + 1

	Comment = ""
	TemplateComment = Temp_Load("Comment.html")
	For PageCount = 0 To UBound( CommentArr, 2 )
		Temp = TemplateComment
		Show_Global_Labels Temp

		If CommentArr(5, PageCount) <> "" Then
			Temp = Replace( Temp, "$Auther$", "<a href=""" & CommentArr(5, PageCount) & """ rel=""external nofollow"">" & CommentArr(3, PageCount) & "</a>" )
		Else
			Temp = Replace( Temp, "$Auther$", CommentArr(3, PageCount) )
		End If
		Temp = Replace( Temp, "$Time$", CommentArr(7, PageCount) & " " & CommentArr(8, PageCount) )
		If CommentArr(14, PageCount) = True Then
			Temp = Replace( Temp, "$Content$", CommentArr(9, PageCount) )
		Else
			Temp = Replace( Temp, "$Content$", "[此评论需要管理员审核才能显示]" )
		End If
		If CommentArr(10, PageCount) <> "" Then
			Temp = Replace( Temp, "$Reply$", "<div class = ""Main_Comment_Reply""><b>" & CommentArr(10, PageCount) & "</b><span class=""commentinfo""> [" & CommentArr(12, PageCount) & " " & CommentArr(13, PageCount) & "]</span><br />" & CommentArr(11, PageCount) & "</div>" )
		Else
			Temp = Replace( Temp, "$Reply$", "" )
		End If
		If CheckAdmin = True Then
			Temp = Replace( Temp, "$Control$", "<div class = ""Main_Comment_AdminEditor"" id = """ & CommentArr(0, PageCount) & """ style = ""display:none""><form action=""" & BlogPath & "Admin.asp?action=8&id=" & CommentArr(0, PageCount) & """ method = ""post"" name = ""CommentReply"" id = ""CommentReply""><textarea name = ""CommentReply"" rows=""4"" cols=""50""></textarea><br /><input type = ""submit"" name = ""Submit"" class=""Main_Button"" value = ""回复"" /></form></div><div class = ""Main_Comment_AdminInfo"">管理：<a href = ""javascript:ShowHideDiv(" & CommentArr(0, PageCount) & ")"">[回复]</a> <a href=""javascript:if(confirm('确实要删除吗?'))location='" & BlogPath & "Admin.asp?action=9&id=" & CommentArr(0, PageCount) & "'"">[删除]</a></div>" )
		Else
			Temp = Replace( Temp, "$Control$", "" )
		End If
		If CommentArr(4, PageCount) <> "" Then
			Gravatar = Split( CommentArr(4, PageCount), "|" )
			Temp = Replace( Temp, "$Gravatar$", "<img src=""http://www.gravatar.com/avatar.php?gravatar_id=" & Gravatar(1) & "?s=32&amp;d=wavatar&amp;r=G"" height=""32"" width=""32"" alt=""Gravatar"" class=""Gravatar"" />" )
		Else
			Temp = Replace( Temp, "$Gravatar$", "<img src=""" & BlogPath & "Style/" & BlogStyle & "/Images/Gravatar.jpg"" height=""32"" width=""32"" alt=""Gravatar"" class=""Gravatar"" />" )
		End If
		Comment = Comment + Temp
	Next
	Comment = Comment + "<div id=""HiddenComment""></div>"

	ShowComment = Comment
End Function

'--------------------------------------------
' 名称：ShowEditor(IsComment,ShowType)
' 作用：显示编辑器
'--------------------------------------------
Function ShowEditor(IsComment,ShowType)
	Dim Editor
	Editor = "<div id = ""Main_CommentEditor"">"
	If IsComment <> 0 Then
		Editor = Editor + "<form action=""" & BlogPath & "Read.asp?action=1&id=" & IsComment & """ method=""post"" name=""Comment"" id=""Comment"">"
	Else
		Editor = Editor + "<form action=""" & BlogPath & "Guestbook.asp?action=1"" method=""post"" name=""Comment"" id=""Comment"">"
	End If
	Editor = Editor + "<table border=""0"" cellpadding=""2"" cellspacing=""1"">"
	Editor = Editor + "<tr>"
	Editor = Editor + "<td width=""100""></td>"
	Editor = Editor + "<td align=""left""><div id=""Editor_Tips""></div></td>"
	Editor = Editor + "</tr>"
	Editor = Editor + "<tr>"
	If CheckLogin() And ShowType <> 1 Then
		Editor = Editor + "<td width=""100""><div align=""right""></div></td>"
		Editor = Editor + "<td align=""left"">您已经登录为<b>" & Session("UserName") & "<input name=""UserName"" id=""UserName"" type=""hidden"" value=""" & Session("UserName") & """/></b></td>"
	Else
		If ShowType <> 1 Then
			Editor = Editor + "<td width=""100""><div align=""right"">* 昵称&nbsp;&nbsp;</div></td>"
			Editor = Editor + "<td align=""left""><input name=""UserName"" id=""UserName"" type=""text"" maxlength=""16"" value=""" & Request.Cookies("XKLog")("UserName") & """/></td>"
		Else
			Editor = Editor + "<td width=""100""><div align=""right"">* 昵称&nbsp;&nbsp;</div></td>"
			Editor = Editor + "<td align=""left""><input name=""UserName"" id=""UserName"" type=""text"" maxlength=""16"" /></td>"
		End If
	End If
	Editor = Editor + "</tr>"
	If CheckLogin() And ShowType <> 1 Then
		Editor = Editor + "<tr>"
		Editor = Editor + "<td width=""100""></td>"
		Editor = Editor + "<td align=""left""><input name=""Email"" id=""Email"" type=""hidden"" maxlength=""100"" value="""" /><input name=""Index"" id=""Index"" type=""hidden"" maxlength=""100"" value=""""/></td>"
		Editor = Editor + "</tr>"
	Else
		Editor = Editor + "<tr>"
		If ShowType <> 1 Then
			Editor = Editor + "<td width=""100""><div align=""right"">邮箱&nbsp;&nbsp;</div></td>"
			Editor = Editor + "<td align=""left""><input name=""Email"" id=""Email"" type=""text"" maxlength=""100"" value=""" & Request.Cookies("XKLog")("Email") & """ /></td>"
			Editor = Editor + "</tr>"
			Editor = Editor + "<tr>"
			Editor = Editor + "<td width=""100""><div align=""right"">主页&nbsp;&nbsp;</div></td>"
			Editor = Editor + "<td align=""left""><input name=""Index"" id=""Index"" type=""text"" maxlength=""100"" value=""" & Request.Cookies("XKLog")("Index") & """ /></td>"
		Else
			Editor = Editor + "<td width=""100""><div align=""right"">邮箱&nbsp;&nbsp;</div></td>"
			Editor = Editor + "<td align=""left""><input name=""Email"" id=""Email"" type=""text"" maxlength=""100"" /></td>"
			Editor = Editor + "</tr>"
			Editor = Editor + "<tr>"
			Editor = Editor + "<td width=""100""><div align=""right"">主页&nbsp;&nbsp;</div></td>"
			Editor = Editor + "<td align=""left""><input name=""Index"" id=""Index"" type=""text"" maxlength=""100"" /></td>"
		End If
		Editor = Editor + "</tr>"
	End If
	Editor = Editor + "<tr>"
	Editor = Editor + "<td width=""100""><div align=""right"">* 内容&nbsp;&nbsp;</div></td>"
	Editor = Editor + "<td align=""left""><textarea name=""Comment"" id=""CommentText""  rows=""5"" cols=""40""></textarea></td>"
	Editor = Editor + "</tr>"
	If BlogVerify = 0 Or ( BlogVerify = 1 And Not CheckLogin() ) Or ShowType = 1  Then
		Editor = Editor + "<tr>"
		Editor = Editor + "<td width=""100""><div align=""right"">* 验证码&nbsp;&nbsp;</div></td>"
		Editor = Editor + "<td align=""left""><input name=""CheckCode"" id=""CheckCode"" type=""text"" size=""6"" maxlength=""4"" /><img src=""" & BlogPath & "Include/CheckCode.asp"" align=""absmiddle"" /></td>"
		Editor = Editor + "</tr>"
	Else
		Editor = Editor + "<tr>"
		Editor = Editor + "<td width=""100""></td>"
		Editor = Editor + "<td align=""left""><input name=""CheckCode"" id=""CheckCode"" type=""hidden"" size=""6"" maxlength=""4"" value=""1234"" /></td>"
		Editor = Editor + "</tr>"
	End If
	Editor = Editor + "<tr>"
	Editor = Editor + "<td width=""100""><div align=""right""></div></td>"
	If IsComment <> 0 Then
		Editor = Editor + "<td align=""left""><input type=""button"" name=""Submit"" value=""立即发表"" class=""Main_Button"" onclick=""ajax_addcomment('" & BlogPath & "'," & IsComment & "); return false;""/></td>"
	Else
		Editor = Editor + "<td align=""left""><input type=""button"" name=""Submit"" value=""立即发表"" class=""Main_Button"" onclick=""ajax_addguestbook('" & BlogPath & "'); return false;""/></td>"
	End If
	Editor = Editor + "</tr>"
	Editor = Editor + "</table></form></div>"

	ShowEditor = Editor
End Function

'--------------------------------------------
' 名称：ShowLogin()
' 作用：显示登录页
'--------------------------------------------
Function ShowLogin()
	Dim Login
	Login = "<div id = ""Main_Login"">"
	Login = Login + "<div id=""Main_Login_Title"">用户登入 [<a href=""" & BlogPath & "Login.asp?action=Register"">尚未注册？</a>] （带有*号的项目为必填）</div>"
	Login = Login + "<form action=""Login.asp?action=CheckLogin"" method=""post"">"
	Login = Login + "<table border=""0"" cellpadding=""2"" cellspacing=""1"">"
	Login = Login + "<tr>"
	Login = Login + "<td width=""160""><div align=""right"">*用户名&nbsp;&nbsp;</div></td>"
	Login = Login + "<td align=""left""><input name=""UserName"" type=""text"" size=""30"" class=""UserName"" value=""""/></td>"
	Login = Login + "</tr>"
	Login = Login + "<tr>"
	Login = Login + "<td width=""160""><div align=""right"">*密码&nbsp;&nbsp;</div></td>"
	Login = Login + "<td align=""left""><input name=""PassWord"" type=""password"" size=""30"" class=""PassWord"" value=""""/></td>"
	Login = Login + "</tr>"
	Login = Login + "<tr>"
	Login = Login + "<td width=""160"" height=""30""><div align=""right"">* 验证码&nbsp;&nbsp;</div></td>"
	Login = Login + "<td align=""left""><input name=""CheckCode"" type=""text"" class=""Text"" maxlength=""10"" value=""""/><img src=""" & BlogPath & "Include/CheckCode.asp"" align=""absmiddle"" /></td>"
	Login = Login + "</tr>"
	Login = Login + "<tr>"
	Login = Login + "<td width=""160""><div align=""right"">记住我&nbsp;&nbsp;</div></td>"
	Login = Login + "<td align=""left""><input name=""AutoLogin"" type=""checkbox"" value=""1"" /></td>"
	Login = Login + "</tr>"
	Login = Login + "</table>"
	Login = Login + "<div class=""Button""><input type=""submit"" name=""Submit"" class=""Main_Button"" value=""登录"" /> <input name=""Submit2"" type=""reset"" class=""Main_Button"" value=""清除"" /></div>"
	Login = Login + "</form>"
	Login = Login + "</div>"

	ShowLogin = Login
End Function

'--------------------------------------------
' 名称：ShowRegister()
' 作用：显示注册页
'--------------------------------------------
Function ShowRegister()
	Dim Register
	Register = "<div id = ""Main_Panel"">"
	If BlogRegEnable Then
		Register = Register + "<div id=""Main_Panel_Title"">用户注册（带有*号的项目为必填）</div>"
		Register = Register + "<form name=""frm"" action=""Login.asp?action=CheckRegister"" method=""post"">"
		Register = Register + "<table border=""0"" cellpadding=""2"" cellspacing=""1"">"
		Register = Register + "<tr>"
		Register = Register + "<td width=""160"" height=""30""><div align=""right"">* 用户名&nbsp;&nbsp;</div></td>"
		Register = Register + "<td align=""left""><input name=""UserName"" type=""text"" maxlength=""16"" class=""UserName"" value="""" id=""vs"" onblur=""if (this.value.length != 0) {CheckName();}"" onfocus=""if (this.value.length != 0) {CheckName();}"" onclick=""if (this.value.length != 0) {CheckName();}"" /><input id=""PostBack_UserName"" value=""False|$|False|$|False"" type=""hidden""> （长度 2-16 位）<span id=""CheckName""></span></td>"
		Register = Register + "</tr>"
		Register = Register + "<tr>"
		Register = Register + "<td width=""160"" height=""30""><div align=""right"">* 密码&nbsp;&nbsp;</div></td>"
		Register = Register + "<td align=""left""><input name=""PassWord"" type=""password"" maxlength=""16"" class=""PassWord"" id=""cpassword"" value="""" onkeyup=""istrong()"" /> （长度 6-16 位）<span id=""CheckPwds""></span></td>"
		Register = Register + "</tr>"
		Register = Register + "<tr>"
		Register = Register + "<td width=""160"" height=""30""><div align=""right"">密码强度&nbsp;&nbsp;</div></td>"
		Register = Register + "<td align=""left""><img src=""Images/0.gif"" id=""strong"" /></td>"
		Register = Register + "</tr>"
		Register = Register + "<tr>"
		Register = Register + "<td width=""160"" height=""30""><div align=""right"">* 重复密码&nbsp;&nbsp;</div></td>"
		Register = Register + "<td align=""left""><input name=""PassWord2"" type=""password"" maxlength=""16"" class=""PassWord"" value="""" onblur=""if (this.value.length != 0) {CheckPwd();}"" onfocus=""if (this.value.length != 0) {CheckPwd();}"" onclick=""if (this.value.length != 0) {CheckPwd();}"" id=""cConfirmpassword"" /><span id=""CheckPwds2""></span></td>"
		Register = Register + "</tr>"
		Register = Register + "<tr>"
		Register = Register + "<td width=""160"" height=""30""><div align=""right"">E-mail&nbsp;&nbsp;</div></td>"
		Register = Register + "<td align=""left""><input name=""Email"" type=""text"" maxlength=""50"" class=""Text"" value=""""/></td>"
		Register = Register + "</tr>"
		Register = Register + "<tr>"
		Register = Register + "<td width=""160"" height=""30""><div align=""right"">Q Q&nbsp;&nbsp;</div></td>"
		Register = Register + "<td align=""left""><input name=""QQ"" type=""text"" class=""Text"" maxlength=""11"" value=""""/></td>"
		Register = Register + "</tr>"
		Register = Register + "<tr>"
		Register = Register + "<td width=""160"" height=""30""><div align=""right"">主页&nbsp;&nbsp;</div></td>"
		Register = Register + "<td align=""left""><input name=""Index"" type=""text"" class=""Text"" maxlength=""100"" value=""""/></td>"
		Register = Register + "</tr>"
		Register = Register + "<tr>"
		Register = Register + "<td width=""160"" height=""30""><div align=""right"">* 验证码&nbsp;&nbsp;</div></td>"
		Register = Register + "<td align=""left""><input name=""CheckCode"" type=""text"" class=""Text"" maxlength=""10"" value=""""/><img src=""" & BlogPath & "Include/CheckCode.asp"" align=""absmiddle"" /></td>"
		Register = Register + "</tr>"
		Register = Register + "</table>"
		Register = Register + "<div class=""Button""><input type=""button"" name=""Submit"" class=""Main_Button"" value=""注册""  onclick=""IsPost()"" /> <input name=""Submit2"" type=""reset"" class=""Main_Button"" value=""清除"" /></div>"
		Register = Register + "</form>"
	Else
		Register = Register + "<center><b>抱歉，目前不允许注册新用户</b></center>"
	End If
	Register = Register + "</div>"

	ShowRegister = Register
End Function

'--------------------------------------------
' 名称：Show_UserPanel()
' 作用：显示用户面中心
'--------------------------------------------
Function Show_UserPanel()
	Dim Rs, UserPanel
	Set Rs = Server.CreateObject ("adodb.recordset")
	Rs.Open "select * from " & PrefixStr & "User where UserName='" & Session("UserName") & "'", Conn, 1, 1

	UserPanel = "<div id=""Main_Panel"">"
	UserPanel = UserPanel + "<div id=""Main_Panel_Title"">用户中心</div>"
	UserPanel = UserPanel + "<div id=""Main_Panel_Content"">"
	UserPanel = UserPanel + "<form name=""frm"" action=""User.asp?action=edit"" method=""post"" onsubmit=""if (this.Password.value.length<1){alert('请输入你的登录密码!');this.Password.focus();return false}"">"
	UserPanel = UserPanel + "<table width=""100%"" cellpadding=""0"" cellspacing=""0"">"
	UserPanel = UserPanel + "<tr><td align=""right"" width=""85""><strong>     UID&nbsp;&nbsp;</strong></td><td align=""left"" style=""padding:3px;"">" & Rs("UID") & "<input name=""UID"" type=""hidden"" value=""" & Rs("UID") & """/></td></tr>"
	UserPanel = UserPanel + "<tr><td align=""right"" width=""85""><strong>　昵　称&nbsp;&nbsp;</strong></td><td align=""left"" style=""padding:3px;"">" & Rs("UserName") & "</td></tr>"
	UserPanel = UserPanel + "<tr><td align=""right"" width=""85""><strong>　密  码&nbsp;&nbsp;</strong></td><td align=""left"" style=""padding:3px;""><input name=""Password"" type=""password"" size=""18"" class=""Text"" maxlength=""16""/><font color=""#FF0000"">&nbsp;*</font></td></tr>"
	UserPanel = UserPanel + "<tr><td align=""right"" width=""85""><strong>　新密码&nbsp;&nbsp;</strong></td><td align=""left"" style=""padding:3px;""><input name=""NewPassword"" type=""password"" size=""18"" class=""Text"" maxlength=""16""/> 留空则不修改密码</td></tr>"
	UserPanel = UserPanel + "<tr><td align=""right"" width=""85""><strong>重复密码&nbsp;&nbsp;</strong></td><td align=""left"" style=""padding:3px;""><input name=""ConfirmPassword"" type=""password"" size=""18"" class=""Text"" maxlength=""16""/></td></tr>"
	UserPanel = UserPanel + "<tr><td align=""right"" width=""85""><strong>电子邮箱&nbsp;&nbsp;</strong></td><td align=""left"" style=""padding:3px;""><input name=""Email"" type=""text"" size=""38"" class=""Text"" maxlength=""255"" value=""" & Rs("Email") & """ /></td></tr>"
	UserPanel = UserPanel + "<tr><td align=""right"" width=""85""><strong>个人主页&nbsp;&nbsp;</strong></td><td align=""left"" style=""padding:3px;""><input name=""Index"" type=""text"" size=""38"" class=""Text"" maxlength=""255"" value=""" & Rs("Index") & """ /></td></tr>"
	UserPanel = UserPanel + "<tr><td align=""right"" width=""85""><strong> QQ 号码&nbsp;&nbsp;</strong></td><td align=""left"" style=""padding:3px;""><input name=""QQ"" type=""text"" size=""10"" class=""Text"" value=""" & Rs("QQNum") & """/></td></tr>"
	UserPanel = UserPanel + "<tr><td colspan=""2"" align=""center"" style=""padding:3px;""><input name=""submit2"" type=""submit"" class=""Main_Button"" value=""修改""/> <input name=""button"" type=""reset"" class=""Main_Button"" value=""重写""/></td></tr>"
	UserPanel = UserPanel + "</table></form></div></div>"

	Rs.Close
	Set Rs = Nothing
	QueryNum = QueryNum + 1

	Show_UserPanel = UserPanel
End Function
%>